/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.hwmca.fw.service.managedsystem.config;

import com.ibm.hwmca.fw.service.config.XMLListParser;
import com.ibm.hwmca.fw.service.managedsystem.config.ManagedSystemConfigData;
import com.ibm.hwmca.fw.service.system.util.ServiceInterfacesParser;
import com.ibm.hwmca.fw.util.MalformedXMLException;
import com.ibm.hwmca.fw.util.XMLParsingException;
import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.util.LinkedList;
import java.util.List;
import org.w3c.dom.Document;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;
import org.xml.sax.InputSource;
import org.xml.sax.SAXException;
import org.xml.sax.SAXNotRecognizedException;
import org.xml.sax.SAXNotSupportedException;

public class ManagedSystemConfigParser
extends XMLListParser {
    private static final String TRACE_MASKT = "XRVFMSOT";
    private static final String TRACE_MASKF = "XRVFMSPF";
    private static final String TRACE_MASKD = "XRVFMSPD";
    private static final String TAG_MANAGED_SYSTEM_CONFIG = "managed-system-config";
    private static final String TAG_MANAGED_SYSTEM = "managed-system";
    private static final String TAG_FACTORIES = "factories";
    private static final String ATTRIB_NAME = "name";
    private static final String ATTRIB_TYPE = "type";
    private static final String ATTRIB_MODEL = "model";

    public ManagedSystemConfigParser() throws SAXNotRecognizedException, SAXNotSupportedException {
        this.setFeature("http://xml.org/sax/features/validation", true);
        this.setErrorHandler(this);
    }

    public List parseXML(String xmlFile) throws XMLParsingException {
        return this.parseXML(new File(xmlFile));
    }

    public List parseXML(File file) throws XMLParsingException {
        List parsedData = null;
        try {
            this.parse(new InputSource(new FileInputStream(file)));
            Document doc = this.getDocument();
            NodeList nodeList = doc.getElementsByTagName(TAG_MANAGED_SYSTEM_CONFIG);
            if (nodeList != null) {
                parsedData = ManagedSystemConfigParser.parseManagedSystems(nodeList.item(0));
            }
        }
        catch (IOException e) {
            throw new XMLParsingException("IOException reading file");
        }
        catch (SAXException e) {
            throw new XMLParsingException("SaxException! " + e);
        }
        return parsedData;
    }

    private static List parseManagedSystems(Node nodeToParse) throws MalformedXMLException {
        LinkedList<ManagedSystemConfigData> parsedData = new LinkedList<ManagedSystemConfigData>();
        NodeList nodes = nodeToParse.getChildNodes();
        for (int aii = 0; aii < nodes.getLength(); ++aii) {
            Node node = nodes.item(aii);
            if (node.getNodeType() != 1 || !node.getNodeName().toLowerCase().equals(TAG_MANAGED_SYSTEM)) continue;
            ManagedSystemConfigData pd = new ManagedSystemConfigData();
            Node tm = node.getAttributes().getNamedItem(ATTRIB_TYPE);
            pd.setType(tm.getNodeValue());
            tm = node.getAttributes().getNamedItem(ATTRIB_MODEL);
            pd.setModel(tm.getNodeValue());
            LinkedList persistenceDefs = new LinkedList();
            NodeList subnodes = node.getChildNodes();
            for (int bii = 0; bii < subnodes.getLength(); ++bii) {
                String tag;
                Node subnode = subnodes.item(bii);
                if (subnode.getNodeType() != 1 || !(tag = subnode.getNodeName().toLowerCase()).equals(TAG_FACTORIES)) continue;
                ServiceInterfacesParser sip = new ServiceInterfacesParser();
                pd.setServiceInterfacesParser(sip);
                try {
                    sip.parseUnkeyedFactories(subnode);
                    continue;
                }
                catch (Exception e) {
                    throw new MalformedXMLException(e);
                }
            }
            parsedData.add(pd);
        }
        return parsedData;
    }
}

